/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.CECByte;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.ErrorDataBlock;
import com.quantumdata.busmon.parser.FiveVoltSenseDataBlock;
import com.quantumdata.busmon.parser.HotplugDataBlock;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.I2CSignal;
import com.quantumdata.busmon.parser.ProgramDataBlock;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.BufferUnderflowException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packet
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected int ordinal;
    protected int version;
    protected long dataBlockSize;
    protected DataBlock dataBlock;
    protected Integer[] rawPacketData;
    public static final short SOURCE_EMPTY = 0;
    public static final short SOURCE_CEC = 1;
    public static final short SOURCE_I2C = 2;
    public static final short SOURCE_HOTPLUG = 3;
    public static final short SOURCE_ERROR = 4;
    public static final short SOURCE_5VOLTSENSE = 5;
    public static final short SOURCE_DISPLAYPORT = 6;
    public static final short SOURCE_PROGRAM = 1000;
    public static final short SOURCE_UNKNOWN = -1;

    public String getSourceName() {
        return this.dataBlock.getSourceName();
    }

    public Packet() {
        this.rawPacketData = new Integer[0];
    }

    public Packet(Integer[] integerArray, int n) {
        this.parse(integerArray);
        this.ordinal = n;
    }

    public Packet(Vector<Integer> vector, int n) {
        Integer[] integerArray = new Integer[vector.size()];
        this.parse(vector.toArray(integerArray));
        this.ordinal = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.ordinal);
        int n = this.rawPacketData.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeInt(this.rawPacketData[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.clear();
        this.ordinal = objectInput.readInt();
        int n = objectInput.readInt();
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = objectInput.readInt();
        }
        this.parse(integerArray);
    }

    public void clear() {
        this.dataBlockSize = 0L;
        this.dataBlock = null;
    }

    public static int getPacketSource(Integer[] integerArray) {
        int n = TypeConverter.composeInt(integerArray, 1);
        return n;
    }

    public static int getPacketSource(Vector<Integer> vector) {
        Integer[] integerArray = new Integer[vector.size()];
        return Packet.getPacketSource(vector.toArray(integerArray));
    }

    public static int getCECDataBlockSourceID(Integer[] integerArray) {
        int n = integerArray[7];
        return n;
    }

    public static int getCECDataBlockSourceID(Vector<Integer> vector) {
        Integer[] integerArray = new Integer[vector.size()];
        return Packet.getCECDataBlockSourceID(vector.toArray(integerArray));
    }

    public void parse(Integer[] integerArray) {
        boolean bl = true;
        if (integerArray == null) {
            return;
        }
        if (integerArray.length == 0) {
            return;
        }
        this.rawPacketData = (Integer[])integerArray.clone();
        try {
            int n = this.rawPacketData[0];
            switch (n) {
                case 1: {
                    int n2 = TypeConverter.composeInt(this.rawPacketData, 1);
                    this.dataBlockSize = TypeConverter.composeLong(this.rawPacketData, 3);
                    switch (n2) {
                        case 1: {
                            this.dataBlock = new CECDataBlock(this.rawPacketData);
                            break;
                        }
                        case 2: {
                            this.dataBlock = new I2CDataBlock(this.rawPacketData);
                            break;
                        }
                        case 3: {
                            this.dataBlock = new HotplugDataBlock(this.rawPacketData);
                            break;
                        }
                        case 4: {
                            this.dataBlock = new ErrorDataBlock(this.rawPacketData);
                            break;
                        }
                        case 5: {
                            this.dataBlock = new FiveVoltSenseDataBlock(this.rawPacketData);
                            break;
                        }
                        case 6: {
                            this.dataBlock = new DisplayPortDataBlock(this.rawPacketData);
                            break;
                        }
                        case 0: {
                            bl = false;
                            break;
                        }
                        case 1000: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        this.dataBlock = null;
                    }
                    return;
                }
            }
            this.dataBlock = new ProgramDataBlock(1);
            bl = false;
            return;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.clear();
            return;
        }
    }

    public short getSource() {
        if (this.dataBlock == null) {
            return 0;
        }
        return this.dataBlock.getSource();
    }

    public long getDataBlockSize() {
        return this.dataBlockSize;
    }

    public boolean isError() {
        if (this.dataBlock == null) {
            return false;
        }
        if (this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).getMessage() == null && ((I2CDataBlock)this.dataBlock).getRawMessage() != null) {
            return true;
        }
        return this.dataBlock.isError();
    }

    public boolean isEDID() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isEDID();
    }

    public boolean isLT() {
        if (this.dataBlock == null) {
            return false;
        }
        if (this.dataBlock instanceof DisplayPortDataBlock) {
            return this.dataBlock.isLT();
        }
        return false;
    }

    public boolean isMCCS() {
        return this.isDDCCI();
    }

    public boolean isDDCCI() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isDDCCI();
    }

    public boolean isHDCP() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isHDCP();
    }

    public boolean isCEC() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isCEC();
    }

    public boolean isI2C() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isI2C();
    }

    public boolean isEvent() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock.isEvent();
    }

    public boolean isOther() {
        return !this.isDDCCI() && !this.isHDCP() && !this.isEDID() && !this.isCEC() && !this.isEvent() && !this.isLT();
    }

    public boolean isDisplayPort() {
        return this.dataBlock instanceof DisplayPortDataBlock;
    }

    public int getSpeed() {
        if (this.dataBlock == null) {
            return 0;
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            return ((I2CDataBlock)this.dataBlock).getPeriod();
        }
        return 0;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public long getTimestamp() {
        if (this.dataBlock != null) {
            return this.dataBlock.getTimestamp();
        }
        return 0L;
    }

    public String getType() {
        if (this.dataBlock != null) {
            return this.dataBlock.getType();
        }
        return "Empty Packet";
    }

    public String getDirection() {
        return this.dataBlock.getDirection();
    }

    public String getDescription() {
        if (this.dataBlock != null) {
            return this.dataBlock.getType();
        }
        return "Empty Packet";
    }

    public String getDetails() {
        if (this.dataBlock != null) {
            return this.dataBlock.getSummary();
        }
        return "Empty Packet";
    }

    public String getExtendedDetails() {
        if (this.dataBlock != null) {
            return this.dataBlock.getDetails();
        }
        return "Empty Packet";
    }

    public Integer[] getRawData() {
        return (Integer[])this.rawPacketData.clone();
    }

    public DataBlock getDataBlock() {
        return this.dataBlock;
    }

    public String getRawString() {
        StringBuffer stringBuffer;
        block5: {
            block6: {
                block4: {
                    if (this.dataBlock == null) {
                        return "";
                    }
                    stringBuffer = new StringBuffer();
                    if (!(this.dataBlock instanceof I2CDataBlock)) break block4;
                    Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
                    for (int i = 0; i < vector.size(); ++i) {
                        stringBuffer.append(String.format("%c", Character.valueOf((char)vector.get(i).getData())));
                    }
                    break block5;
                }
                if (!(this.dataBlock instanceof CECDataBlock)) break block6;
                Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append(String.format("%02X", vector.get(i).getData()));
                }
                break block5;
            }
            if (!(this.dataBlock instanceof DisplayPortDataBlock)) break block5;
            Integer[] integerArray = ((DisplayPortDataBlock)this.dataBlock).getRawMessage();
            for (int i = 0; i < integerArray.length; ++i) {
                stringBuffer.append(String.format("%02X", (int)integerArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    public String getHexString() {
        if (this.dataBlock == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dataBlock instanceof I2CDataBlock) {
            Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(String.format("%02X", vector.get(i).getData()));
            }
        } else if (this.dataBlock instanceof CECDataBlock) {
            Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(String.format("%02X", vector.get(i).getData()));
            }
        } else if (this.dataBlock instanceof DisplayPortDataBlock) {
            DisplayPortDataBlock displayPortDataBlock = (DisplayPortDataBlock)this.dataBlock;
            Integer[] integerArray = displayPortDataBlock.getRawMessage();
            String string = new String("No Data");
            if (integerArray.length >= 14) {
                int n;
                Integer[] integerArray2 = new Integer[integerArray.length - 13];
                for (n = 13; n < integerArray.length; ++n) {
                    integerArray2[n - 13] = integerArray[n];
                }
                for (n = 0; n < integerArray2.length; ++n) {
                    stringBuffer.append(String.format("%02X", (int)integerArray2[n]));
                }
            } else {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getHex() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (this.rawPacketData == null || this.rawPacketData.length == 0) {
            return "No binary data for this packet type.";
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            int n;
            Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
            if (vector == null) {
                return "No data.";
            }
            if (vector.size() == 0) {
                return "No data.";
            }
            stringBuffer.append(String.format("Data Size: %d packets\n", vector.size()));
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                I2CSignal i2CSignal = vector.get(i);
                if (bl) {
                    for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer2 != null && stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                }
                switch (i2CSignal.getType()) {
                    case 1: {
                        stringBuffer3.append("\n* START *");
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (bl) {
                            stringBuffer.append(String.format("%04X  ", n2));
                            for (n = 0; n < n2 % 8; ++n) {
                                stringBuffer2.append("   ");
                                stringBuffer3.append("  ");
                            }
                            bl = false;
                        }
                        stringBuffer2.append(String.format("%02X", i2CSignal.getData()));
                        if (i2CSignal.getData() > 32 && i2CSignal.getData() < 127) {
                            stringBuffer3.append(String.format("%c ", i2CSignal.getData()));
                        } else {
                            stringBuffer3.append(". ");
                        }
                        stringBuffer2.append(i2CSignal.getAck() ? " " : "-");
                        ++n2;
                        break;
                    }
                    case 3: {
                        stringBuffer3.append("\n* STOP *");
                        bl = true;
                        break;
                    }
                }
                if (n2 % 8 != 0) continue;
                bl = true;
            }
            for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                stringBuffer2.append("   ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer2 != null && stringBuffer3 != null) {
                stringBuffer.append(" | ");
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(stringBuffer3);
            }
            return stringBuffer.toString();
        }
        if (this.dataBlock instanceof CECDataBlock) {
            int n;
            int n3;
            Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
            if (vector == null) {
                return "No data.";
            }
            if (vector.size() == 0) {
                return "No data.";
            }
            stringBuffer.append(String.format("Data Size: %d bytes\n", vector.size()));
            boolean bl = false;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                if (n3 % 4 == 0) {
                    bl = true;
                }
                CECByte cECByte = vector.get(n3);
                if (bl) {
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer2 != null && stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                    stringBuffer.append(String.format("%04X  ", n3));
                    for (n = 0; n < n3 % 4; ++n) {
                        stringBuffer2.append("    ");
                        stringBuffer3.append("  ");
                    }
                    bl = false;
                }
                stringBuffer2.append(cECByte.toString());
                if (cECByte.getData() > 32 && cECByte.getData() < 127) {
                    stringBuffer3.append(String.format("%c ", cECByte.getData()));
                } else {
                    stringBuffer3.append(". ");
                }
                stringBuffer2.append(cECByte.getACK() ? "+" : "-");
                stringBuffer2.append(cECByte.getEOM() ? "." : " ");
            }
            for (n = 0; n < 3 - (n3 - 1) % 4; ++n) {
                stringBuffer2.append("    ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(" | ");
                stringBuffer.append(stringBuffer3);
            }
            return stringBuffer.toString();
        }
        if (this.dataBlock instanceof DisplayPortDataBlock) {
            DisplayPortDataBlock displayPortDataBlock = (DisplayPortDataBlock)this.dataBlock;
            Integer[] integerArray = displayPortDataBlock.getRawMessage();
            String string = new String("No Data");
            if (integerArray.length >= 14) {
                Integer[] integerArray2 = new Integer[integerArray.length - 13];
                for (int i = 13; i < integerArray.length; ++i) {
                    integerArray2[i - 13] = integerArray[i];
                }
                string = displayPortDataBlock.getHexRepresentation(integerArray2);
            }
            return string;
        }
        return "Hex data does not exist for this packet type.\n";
    }

    public static String getSourceName(short s) {
        String string = "Unknown";
        switch (s) {
            case 0: {
                string = "Empty";
                break;
            }
            case 1: {
                string = "CEC";
                break;
            }
            case 2: {
                string = "I2C";
                break;
            }
            case 3: {
                string = "HOTPLUG";
                break;
            }
            case 4: {
                string = "Error";
                break;
            }
            case 1000: {
                string = "Program";
                break;
            }
            case 5: {
                string = "5-Volt Sense";
                break;
            }
            case 6: {
                string = "DPCD";
            }
        }
        return string;
    }
}

